#version 330
#extension GL_EXT_gpu_shader4 : enable
// Basic Knot ShaderMod01.fsh  by  Akko

//https://www.shadertoy.com/view/lsBBDt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926535894932384626
#define DELTA_X vec3(0.001, 0, 0)
#define DELTA_Y vec3(0, 0.001, 0)
#define DELTA_Z vec3(0, 0, 0.001)
#define LIGHT_POS vec3(20.0, 30.0, 30.0)
#define LIGHT_SIZE 3.0
#define LIGHT_COLOR vec3(0.7, 0.7, 0.7)
#define AMBIENT vec3(0.2, 0.2, 0.2)

vec3 cylinder2cartesian(float r, float phi, float z)
{
    return vec3(r * cos(phi), r * sin(phi), z);
}

float dist_estimator(in vec3 pos)
{
    float r = length(pos);
    float phi = atan(pos.y, pos.x);
    float r1 = sin(1.5 * phi) + 1.5;
    float z1 = cos(1.5 * phi);
    float r2 = sin(1.5 * phi + PI) + 1.5;
    float z2 = cos(1.5 * phi + PI);
   	vec3 p1 = cylinder2cartesian(r1, phi, z1);
    vec3 p2 = cylinder2cartesian(r2, phi, z2);
    return (min(distance(pos, p1), distance(pos, p2)) - 0.3) / 4.0;
}

vec3 get_normal(in vec3 pos)
{
    return normalize(vec3(dist_estimator(pos + DELTA_X) - dist_estimator(pos - DELTA_X),
                          dist_estimator(pos + DELTA_Y) - dist_estimator(pos - DELTA_Y),
                          dist_estimator(pos + DELTA_Z) - dist_estimator(pos - DELTA_Z)));
}

// For more accurate shadow.
float shadow_round2(in vec3 src, in vec3 drt, float dist)
{
    float res = 0.0, t = 0.1;
    for (int i = 0; i < 5; ++i)
    {
        float delta = dist_estimator(src + t * drt);
        float radius = LIGHT_SIZE * t / dist;
        t += delta + radius;
        res = max(res, clamp(-delta / radius, 0.0, 1.0));
    }
    return res;
}

// Using cone tracing to calculate the soft shadow.
float shadow(in vec3 src, in vec3 drt)
{
    float res = 1.0, t = 0.1, dist = distance(src, LIGHT_POS), res_pos;
    for (int i = 0; i < 50; ++i)
    {
        float delta = dist_estimator(src + t * drt);
        float radius = LIGHT_SIZE * t / dist;
        if (delta < -radius)
            return 0.0;
        t += delta + radius;
        float cur_res = clamp(delta / radius, -1.0, 1.0);
        if (cur_res < res)
        {
            res = min(res, clamp(delta / radius, -1.0, 1.0));
            res_pos = t;
        }
        if (t > dist)
        {
            float size1 = (acos(res) - res * sqrt(1.0 - res * res)) / PI;
            if (size1 < 0.1)
                return 1.0 - size1;
            // shadow round 2.
            vec3 normal = get_normal(src + drt * res_pos);
            vec3 drt2 = normalize(drt + normal * LIGHT_SIZE / dist);
            float res2 = 1.0 - shadow_round2(src, drt2, dist);
            float size2 = (acos(res2) - res2 * sqrt(1.0 - res2 * res2)) / PI;
            return max(1.0 - size1 - size2, 0.0);
        }
    }
    return 0.0;
}

float intersects(in vec3 src, in vec3 drt)
{
    float t;
   	for (int i = 0; i < 150; ++i)
    {
       	float delta = dist_estimator(src + t * drt);
        t += delta;
        if (delta < 1e-6)
            break;
    }
   	return t;
}

vec4 trace(in vec3 src, in vec3 dst)
{
    vec3 drt = normalize(dst - src);
    vec3 light = vec3(0, 0, 3.0);
    float t = intersects(src, drt);
    if (t <= 20.0)
    {
    	vec3 surface_pos = src+ drt * t;
        vec3 light_drt = normalize(LIGHT_POS - surface_pos);
        float strenth = shadow(surface_pos, light_drt) * max(dot(get_normal(surface_pos), light_drt), 0.0);
        return vec4(LIGHT_COLOR * strenth + AMBIENT, 1);
    }
    else
        return vec4(0, 0, 0, 1);
}

vec3 camera(in vec3 src, in vec3 lookat, in vec3 up, in vec2 uv)
{
    vec3 lookat_ = normalize(lookat - src);
    vec3 right_ = normalize(cross(lookat_, up));
    vec3 up_ = normalize(cross(right_, lookat_));
    return src + lookat_ + (right_ * uv.x + up_ * uv.y) * 0.4;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (vec2(gl_FragCoord.x - iResolution.x / 2.0, gl_FragCoord.y - iResolution.y / 2.0) / max(iResolution.x, iResolution.y)) * 2.0;
    vec3 src = vec3(6.0 * cos(iTime / 2.0), 6.0 * sin(iTime / 2.0), 12.0);
    vec3 lookat = vec3(0.0, 0.0, 0.0);
    vec3 up = vec3(0.0, 1.0, 0.0);
    gl_FragColor = trace(src, camera(src, lookat, up, uv));
    gl_FragColor.a = (length(gl_FragColor.rgb)*10000000.0);
}

